/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import $ from"jquery";import*as TreeComponent from"@typo3/form/backend/form-editor/tree-component.js";import*as ModalsComponent from"@typo3/form/backend/form-editor/modals-component.js";import*as InspectorComponent from"@typo3/form/backend/form-editor/inspector-component.js";import*as StageComponent from"@typo3/form/backend/form-editor/stage-component.js";import*as Helper from"@typo3/form/backend/form-editor/helper.js";import Icons from"@typo3/backend/icons.js";import Notification from"@typo3/backend/notification.js";import{loadModule}from"@typo3/core/java-script-item-processor.js";const configuration={domElementClassNames:{formElementIsComposit:"t3-form-element-composit",formElementIsTopLevel:"t3-form-element-toplevel",hasError:"has-error",headerButtonBar:"module-docheader-bar-column-left",selectedCompositFormElement:"t3-form-form-composit-element-selected",selectedFormElement:"t3-form-form-element-selected",selectedRootFormElement:"t3-form-root-element-selected",selectedStagePanel:"t3-form-form-stage-selected",sortableHover:"sortable-hover",stageViewModeAbstract:"t3-form-stage-viewmode-abstract",stageViewModePreview:"t3-form-stage-viewmode-preview",validationErrors:"t3-form-validation-errors",validationChildHasErrors:"t3-form-validation-child-has-error"},domElementDataAttributeNames:{abstractType:"data-element-abstract-type"},domElementDataAttributeValues:{buttonHeaderClose:"closeButton",buttonHeaderNewPage:"headerNewPage",buttonHeaderPaginationNext:"buttonPaginationNext",buttonHeaderPaginationPrevious:"buttonPaginationPrevious",buttonHeaderRedo:"redoButton",buttonHeaderSave:"saveButton",buttonHeaderSettings:"formSettingsButton",buttonHeaderUndo:"undoButton",buttonHeaderViewModeAbstract:"buttonViewModeAbstract",buttonHeaderViewModePreview:"buttonViewModePreview",buttonStageNewElementBottom:"stageNewElementBottom",buttonStructureNewPage:"treeNewPageBottom",iconMailform:"content-form",iconSave:"actions-document-save",iconSaveSpinner:"spinner-circle",inspectorSection:"inspectorSection",moduleLoadingIndicator:"moduleLoadingIndicator",moduleWrapper:"moduleWrapper",stageArea:"stageArea",stageContainer:"stageContainer",stageContainerInner:"stageContainerInner",stageNewElementRow:"stageNewElementRow",stagePanelHeading:"panelHeading",stageSection:"stageSection",structure:"structure-element",structureSection:"structureSection",structureRootContainer:"treeRootContainer",structureRootElement:"treeRootElement"},panels:{structure:{width:300},stage:{marginLeft:300,marginRight:325,marginLeftCollapsed:0,marginRightCollapsed:-25,maxWidthPreview:1e3,maxWidthAbstract:800},inspector:{width:350}}};let previewMode=!1,formEditorApp=null,structureComponent=null,modalsComponent=null,inspectorsComponent=null,stageComponent=null;function getRootFormElement(){return getFormEditorApp().getRootFormElement()}function assert(e,t,o){return getFormEditorApp().assert(e,t,o)}function getUtility(){return getFormEditorApp().getUtility()}function getCurrentlySelectedFormElement(){return getFormEditorApp().getCurrentlySelectedFormElement()}function getPublisherSubscriber(){return getFormEditorApp().getPublisherSubscriber()}function addPropertyValidators(){getFormEditorApp().addPropertyValidationValidator("NotEmpty",(function(e,t){const o=e.get(t);if(""===o||$.isArray(o)&&!o.length)return getFormEditorApp().getFormElementPropertyValidatorDefinition("NotEmpty").errorMessage||"invalid value"})),getFormEditorApp().addPropertyValidationValidator("Integer",(function(e,t){if(!$.isNumeric(e.get(t)))return getFormEditorApp().getFormElementPropertyValidatorDefinition("Integer").errorMessage||"invalid value"})),getFormEditorApp().addPropertyValidationValidator("IntegerOrEmpty",(function(e,t){if(!getUtility().isUndefinedOrNull(e.get(t)))return e.get(t).length>0&&!$.isNumeric(e.get(t))?getFormEditorApp().getFormElementPropertyValidatorDefinition("Integer").errorMessage||"invalid value":void 0})),getFormEditorApp().addPropertyValidationValidator("NaiveEmail",(function(e,t){if(!getUtility().isUndefinedOrNull(e.get(t)))return e.get(t).match(/\S+@\S+\.\S+/)?void 0:getFormEditorApp().getFormElementPropertyValidatorDefinition("NaiveEmail").errorMessage||"invalid value"})),getFormEditorApp().addPropertyValidationValidator("NaiveEmailOrEmpty",(function(e,t){if(!getUtility().isUndefinedOrNull(e.get(t)))return e.get(t).length>0&&!e.get(t).match(/\S+@\S+\.\S+/)?getFormEditorApp().getFormElementPropertyValidatorDefinition("NaiveEmailOrEmpty").errorMessage||"invalid value":void 0})),getFormEditorApp().addPropertyValidationValidator("FormElementIdentifierWithinCurlyBracesInclusive",(function(e,t){if(getUtility().isUndefinedOrNull(e.get(t)))return;const o=/\{([a-z0-9-_]+)?\}/gi.exec(e.get(t));return o&&(o[1]&&"__currentTimestamp"!==o[1]&&!getFormEditorApp().isFormElementIdentifierUsed(o[1])||!o[1])?getFormEditorApp().getFormElementPropertyValidatorDefinition("FormElementIdentifierWithinCurlyBracesInclusive").errorMessage||"invalid value":void 0})),getFormEditorApp().addPropertyValidationValidator("FormElementIdentifierWithinCurlyBracesExclusive",(function(e,t){if(getUtility().isUndefinedOrNull(e.get(t)))return;const o=/^\{([a-z0-9-_]+)?\}$/i.exec(e.get(t));return!o||o[1]&&"__currentTimestamp"!==o[1]&&!getFormEditorApp().isFormElementIdentifierUsed(o[1])||!o[1]?getFormEditorApp().getFormElementPropertyValidatorDefinition("FormElementIdentifierWithinCurlyBracesInclusive").errorMessage||"invalid value":void 0})),getFormEditorApp().addPropertyValidationValidator("FileSize",(function(e,t){if(!getUtility().isUndefinedOrNull(e.get(t)))return e.get(t).match(/^(\d*\.?\d+)(B|K|M|G)$/i)?void 0:getFormEditorApp().getFormElementPropertyValidatorDefinition("FileSize").errorMessage||"invalid value"})),getFormEditorApp().addPropertyValidationValidator("RFC3339FullDate",(function(e,t){if(!getUtility().isUndefinedOrNull(e.get(t)))return e.get(t).match(/^([0-9]{4})-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])$/i)?void 0:getFormEditorApp().getFormElementPropertyValidatorDefinition("RFC3339FullDate").errorMessage||"invalid value"})),getFormEditorApp().addPropertyValidationValidator("RFC3339FullDateOrEmpty",(function(e,t){if(!getUtility().isUndefinedOrNull(e.get(t)))return e.get(t).length>0&&!e.get(t).match(/^([0-9]{4})-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])$/i)?getFormEditorApp().getFormElementPropertyValidatorDefinition("RFC3339FullDate").errorMessage||"invalid value":void 0})),getFormEditorApp().addPropertyValidationValidator("RegularExpressionPattern",(function(e,t){const o=e.get(t);let r=!0;if(!getUtility().isNonEmptyString(o))return getFormEditorApp().getFormElementPropertyValidatorDefinition("RegularExpressionPattern").errorMessage||"invalid value";try{const e=o.match(/^\/(.*)\/[gmixsuUAJD]*$/);null!==e?new RegExp(e[1]):r=!1}catch{r=!1}return r?void 0:getFormEditorApp().getFormElementPropertyValidatorDefinition("RegularExpressionPattern").errorMessage||"invalid value"}))}function loadAdditionalModules(e){let t=[];if("object"!=typeof e||Array.isArray(e))t=e;else for(const o of Object.keys(e))t.push(e[o]);if("array"!==$.type(t))return void getPublisherSubscriber().publish("view/ready");const o=t.length;if(o>0){let e=0;for(let r=0;r<o;++r)loadModule(t[r]).then((function(n){assert("function"===$.type(n.bootstrap),'The module "'+t[r].name+'" does not implement the method "bootstrap"',1475425785),n.bootstrap(getFormEditorApp()),e++,o===e&&getPublisherSubscriber().publish("view/ready")}))}else getPublisherSubscriber().publish("view/ready")}function structureComponentSetup(){assert("function"===$.type(TreeComponent.bootstrap),'The structure component does not implement the method "bootstrap"',1478268639),structureComponent=TreeComponent.bootstrap(getFormEditorApp(),$(getHelper().getDomElementDataAttribute("identifier","bracesWithKeyValue",[getHelper().getDomElementDataAttributeValue("structure")]))),$(getHelper().getDomElementDataIdentifierSelector("iconMailform"),$(getHelper().getDomElementDataIdentifierSelector("structureRootContainer"))).attr("title","identifier: "+getRootFormElement().get("identifier"))}function modalsComponentSetup(){assert("function"===$.type(ModalsComponent.bootstrap),'The modals component does not implement the method "bootstrap"',1478895106),modalsComponent=ModalsComponent.bootstrap(getFormEditorApp())}function inspectorsComponentSetup(){assert("function"===$.type(InspectorComponent.bootstrap),'The inspector component does not implement the method "bootstrap"',1478895106),inspectorsComponent=InspectorComponent.bootstrap(getFormEditorApp())}function stageComponentSetup(){assert("function"===$.type(InspectorComponent.bootstrap),'The stage component does not implement the method "bootstrap"',1478986610),stageComponent=StageComponent.bootstrap(getFormEditorApp(),$(getHelper().getDomElementDataAttribute("identifier","bracesWithKeyValue",[getHelper().getDomElementDataAttributeValue("stageArea")]))),getStage().getStagePanelDomElement().on("click",(function(e){$(e.target).attr(getHelper().getDomElementDataAttribute("identifier"))!==getHelper().getDomElementDataAttributeValue("stagePanelHeading")&&$(e.target).attr(getHelper().getDomElementDataAttribute("identifier"))!==getHelper().getDomElementDataAttributeValue("stageSection")&&$(e.target).attr(getHelper().getDomElementDataAttribute("identifier"))!==getHelper().getDomElementDataAttributeValue("stageArea")||selectPageBatch(getFormEditorApp().getCurrentlySelectedPageIndex()),getPublisherSubscriber().publish("view/stage/panel/clicked",[])}))}function buttonsSetup(){$(getHelper().getDomElementDataIdentifierSelector("buttonHeaderSave")).on("click",(function(){getPublisherSubscriber().publish("view/header/button/save/clicked",[])})),$(getHelper().getDomElementDataIdentifierSelector("buttonHeaderSettings")).on("click",(function(){getPublisherSubscriber().publish("view/header/formSettings/clicked",[])})),$(getHelper().getDomElementDataIdentifierSelector("buttonStageNewElementBottom")).on("click",(function(){getPublisherSubscriber().publish("view/stage/abstract/button/newElement/clicked",["view/insertElements/perform/bottom"])})),$(getHelper().getDomElementDataIdentifierSelector("buttonHeaderNewPage")).on("click",(function(){getPublisherSubscriber().publish("view/header/button/newPage/clicked",["view/insertPages/perform"])})),$(getHelper().getDomElementDataIdentifierSelector("buttonStructureNewPage")).on("click",(function(){getPublisherSubscriber().publish("view/structure/button/newPage/clicked",["view/insertPages/perform"])})),$(getHelper().getDomElementDataIdentifierSelector("buttonHeaderClose")).on("click",(function(e){getFormEditorApp().getUnsavedContent()&&(e.preventDefault(),getPublisherSubscriber().publish("view/header/button/close/clicked",[]))})),$(getHelper().getDomElementDataIdentifierSelector("buttonHeaderUndo")).on("click",(function(){getPublisherSubscriber().publish("view/undoButton/clicked",[])})),$(getHelper().getDomElementDataIdentifierSelector("buttonHeaderRedo")).on("click",(function(){getPublisherSubscriber().publish("view/redoButton/clicked",[])})),$(getHelper().getDomElementDataIdentifierSelector("buttonHeaderViewModeAbstract")).on("click",(function(){getPublisherSubscriber().publish("view/viewModeButton/abstract/clicked",[])})),$(getHelper().getDomElementDataIdentifierSelector("buttonHeaderViewModePreview")).on("click",(function(){getPublisherSubscriber().publish("view/viewModeButton/preview/clicked",[])})),$(getHelper().getDomElementDataIdentifierSelector("structureRootContainer")).on("click",(function(){getPublisherSubscriber().publish("view/structure/root/selected")})),$(getHelper().getDomElementDataIdentifierSelector("buttonHeaderPaginationNext")).on("click",(function(){getPublisherSubscriber().publish("view/paginationNext/clicked",[])})),$(getHelper().getDomElementDataIdentifierSelector("buttonHeaderPaginationPrevious")).on("click",(function(){getPublisherSubscriber().publish("view/paginationPrevious/clicked",[])}))}export function getFormEditorApp(){return formEditorApp}export function getHelper(e){return getUtility().isUndefinedOrNull(e)?Helper.setConfiguration(configuration):Helper.setConfiguration(e)}export function getFormElementDefinition(e,t){return getFormEditorApp().getFormElementDefinition(e,t)}export function getConfiguration(){return $.extend(!0,{},configuration)}export function getPreviewMode(){return previewMode}export function setPreviewMode(e){previewMode=!!e}export function getStructure(){return structureComponent}export function renewStructure(){getStructure().renew(),getPublisherSubscriber().publish("view/structure/renew/postProcess")}export function addStructureSelection(e){getStructure().getTreeNode(e).addClass(getHelper().getDomElementClassName("selectedFormElement"))}export function removeStructureSelection(e){getStructure().getTreeNode(e).removeClass(getHelper().getDomElementClassName("selectedFormElement"))}export function removeAllStructureSelections(){$(getHelper().getDomElementClassName("selectedFormElement",!0),getStructure().getTreeDomElement()).removeClass(getHelper().getDomElementClassName("selectedFormElement"))}export function getStructureRootElement(){return $(getHelper().getDomElementDataAttribute("identifier","bracesWithKeyValue",[getHelper().getDomElementDataAttributeValue("structureRootElement")]))}export function removeStructureRootElementSelection(){$(getHelper().getDomElementDataAttribute("identifier","bracesWithKeyValue",[getHelper().getDomElementDataAttributeValue("structureRootContainer")])).removeClass(getHelper().getDomElementClassName("selectedRootFormElement"))}export function addStructureRootElementSelection(){$(getHelper().getDomElementDataAttribute("identifier","bracesWithKeyValue",[getHelper().getDomElementDataAttributeValue("structureRootContainer")])).addClass(getHelper().getDomElementClassName("selectedRootFormElement"))}export function setStructureRootElementTitle(e){getUtility().isUndefinedOrNull(e)&&(e=$("<span></span>").text(getRootFormElement().get("label")?getRootFormElement().get("label"):getRootFormElement().get("identifier")).text()),getStructureRootElement().text(e)}export function addStructureValidationResults(){getStructure().getAllTreeNodes().removeClass(getHelper().getDomElementClassName("validationErrors")).removeClass(getHelper().getDomElementClassName("validationChildHasErrors")),removeElementValidationErrorClass(getStructureRootElement());const e=getFormEditorApp().validateFormElementRecursive(getRootFormElement());for(let t=0,o=e.length;t<o;++t){let o=!1;for(let r=0,n=e[t].validationResults.length;r<n;++r)if(e[t].validationResults[r].validationResults&&e[t].validationResults[r].validationResults.length>0){o=!0;break}if(o)if(0===t)setElementValidationErrorClass(getStructureRootElement());else{let o=getStructure().getTreeNode(e[t].formElementIdentifierPath);setElementValidationErrorClass(o);const r=e[t].formElementIdentifierPath.split("/");for(;r.pop();)o=getStructure().getTreeNode(r.join("/")),"object"===$.type(o)&&setElementValidationErrorClass(o,"validationChildHasErrors")}}}export function getModals(){return modalsComponent}export function showRemoveFormElementModal(e){getUtility().isUndefinedOrNull(e)&&(e=getCurrentlySelectedFormElement()),getModals().showRemoveFormElementModal(e)}export function showRemoveCollectionElementModal(e,t,o){getUtility().isUndefinedOrNull(o)&&(o=getCurrentlySelectedFormElement()),getModals().showRemoveCollectionElementModal(e,t,o)}export function showCloseConfirmationModal(){getModals().showCloseConfirmationModal()}export function showInsertElementsModal(e,t){getModals().showInsertElementsModal(e,t)}export function showInsertPagesModal(e){getModals().showInsertPagesModal(e)}export function showValidationErrorsModal(){const e=getFormEditorApp().validateFormElementRecursive(getRootFormElement());getModals().showValidationErrorsModal(e)}export function getInspector(){return inspectorsComponent}export function renderInspectorEditors(e,t){getUtility().isUndefinedOrNull(t)&&(t=!0);const o=t=>{getInspector().renderEditors(e,t)};t?getInspector().getInspectorDomElement().fadeOut("fast",(function(){o((function(){getInspector().getInspectorDomElement().fadeIn("fast")}))})):o()}export function renderInspectorCollectionElementEditors(e,t){getInspector().renderCollectionElementEditors(e,t)}export function getStage(){return stageComponent}export function setStageHeadline(e){getStage().setStageHeadline(e)}export function addStagePanelSelection(){getStage().getStagePanelDomElement().addClass(getHelper().getDomElementClassName("selectedStagePanel"))}export function removeStagePanelSelection(){getStage().getStagePanelDomElement().removeClass(getHelper().getDomElementClassName("selectedStagePanel"))}export function renderPagination(){getStage().renderPagination()}export function renderUndoRedo(){getStage().renderUndoRedo()}export function renderAbstractStageArea(e,t){$(getHelper().getDomElementDataIdentifierSelector("structureSection")).animate({"inset-inline-start":"0px"},"slow"),$(getHelper().getDomElementDataIdentifierSelector("inspectorSection")).animate({"inset-inline-end":"0px"},"slow"),$(getHelper().getDomElementDataIdentifierSelector("stageContainer")).animate({"margin-inline-start":configuration.panels.stage.marginLeft+"px","margin-inline-end":configuration.panels.stage.marginRight+"px"},"slow"),$(getHelper().getDomElementDataIdentifierSelector("stageContainerInner")).animate({"max-width":configuration.panels.stage.maxWidthAbstract+"px"},"slow"),$(getHelper().getDomElementClassName("headerButtonBar",!0)).animate({"margin-inline-start":configuration.panels.structure.width+"px"},"slow"),getUtility().isUndefinedOrNull(e)&&(e=!0),getUtility().isUndefinedOrNull(t)&&(t=!0),setButtonActive($(getHelper().getDomElementDataIdentifierSelector("buttonHeaderViewModeAbstract"))),removeButtonActive($(getHelper().getDomElementDataIdentifierSelector("buttonHeaderViewModePreview")));const o=e=>{$(getHelper().getDomElementDataIdentifierSelector("stageContainer")).addClass(getHelper().getDomElementClassName("stageViewModeAbstract")).removeClass(getHelper().getDomElementClassName("stageViewModePreview")),getStage().renderAbstractStageArea(void 0,e)},r=()=>{const e=getFormElementDefinition(getCurrentlySelectedFormElement(),void 0);getStage().getAllFormElementDomElements().hover((function(){getStage().getAllFormElementDomElements().parent().removeClass(getHelper().getDomElementClassName("sortableHover")),$(this).parent().hasClass(getHelper().getDomElementClassName("formElementIsComposit"))&&!$(this).parent().hasClass(getHelper().getDomElementClassName("formElementIsTopLevel"))&&$(this).parent().addClass(getHelper().getDomElementClassName("sortableHover"))})),showComponent($(getHelper().getDomElementDataIdentifierSelector("buttonHeaderNewPage"))),!e._isTopLevelFormElement||e._isCompositeFormElement||getFormEditorApp().isRootFormElementSelected()?(showComponent($(getHelper().getDomElementDataIdentifierSelector("buttonStageNewElementBottom"))),showComponent($(getHelper().getDomElementDataIdentifierSelector("stageNewElementRow")))):(hideComponent($(getHelper().getDomElementDataIdentifierSelector("buttonStageNewElementBottom"))),hideComponent($(getHelper().getDomElementDataIdentifierSelector("stageNewElementRow")))),refreshSelectedElementItemsBatch(t),getPublisherSubscriber().publish("view/stage/abstract/render/postProcess")};e?$(getHelper().getDomElementDataIdentifierSelector("stageSection")).fadeOut(400,(function(){o((function(){getPublisherSubscriber().publish("view/stage/abstract/render/preProcess"),$(getHelper().getDomElementDataIdentifierSelector("stageSection")).fadeIn(400),r(),getPublisherSubscriber().publish("view/stage/abstract/render/postProcess")}))})):o((function(){getPublisherSubscriber().publish("view/stage/abstract/render/preProcess"),r(),getPublisherSubscriber().publish("view/stage/abstract/render/postProcess")}))}export function renderPreviewStageArea(e){$(getHelper().getDomElementDataIdentifierSelector("structureSection")).animate({"inset-inline-start":"-"+configuration.panels.structure.width+"px"},"slow"),$(getHelper().getDomElementDataIdentifierSelector("inspectorSection")).animate({"inset-inline-end":"-"+configuration.panels.inspector.width+"px"},"slow"),$(getHelper().getDomElementDataIdentifierSelector("stageContainer")).animate({"margin-inline-start":configuration.panels.stage.marginLeftCollapsed+"px","margin-inline-end":configuration.panels.stage.marginRightCollapsed+"px"},"slow"),$(getHelper().getDomElementDataIdentifierSelector("stageContainerInner")).animate({"max-width":configuration.panels.stage.maxWidthPreview+"px"},"slow"),$(getHelper().getDomElementClassName("headerButtonBar",!0)).animate({"margin-inline-start":configuration.panels.stage.marginLeftCollapsed+"px"},"slow"),setButtonActive($(getHelper().getDomElementDataIdentifierSelector("buttonHeaderViewModePreview"))),removeButtonActive($(getHelper().getDomElementDataIdentifierSelector("buttonHeaderViewModeAbstract"))),$(getHelper().getDomElementDataIdentifierSelector("stageSection")).fadeOut(400,(function(){$(getHelper().getDomElementDataIdentifierSelector("stageContainer")).addClass(getHelper().getDomElementClassName("stageViewModePreview")).removeClass(getHelper().getDomElementClassName("stageViewModeAbstract")),hideComponent($(getHelper().getDomElementDataIdentifierSelector("buttonStageNewElementBottom"))),hideComponent($(getHelper().getDomElementDataIdentifierSelector("buttonHeaderNewPage"))),getStage().renderPreviewStageArea(e),$(getHelper().getDomElementDataIdentifierSelector("stageSection")).fadeIn(400),getPublisherSubscriber().publish("view/stage/preview/render/postProcess")}))}export function addAbstractViewValidationResults(){const e=getFormEditorApp().validateFormElementRecursive(getRootFormElement());for(let t=0,o=e.length;t<o;++t){let o=!1;for(let r=0,n=e[t].validationResults.length;r<n;++r)if(e[t].validationResults[r].validationResults&&e[t].validationResults[r].validationResults.length>0){o=!0;break}if(o&&t>0){setElementValidationErrorClass(getStage().getAbstractViewFormElementDomElement(e[t].formElementIdentifierPath))}}}export function createAndAddFormElement(e,t,o){const r=getFormEditorApp().createAndAddFormElement(e,t);return o||getPublisherSubscriber().publish("view/formElement/inserted",[r]),r}export function moveFormElement(e,t,o,r){const n=getFormEditorApp().moveFormElement(e,t,o,!1);return r||getPublisherSubscriber().publish("view/formElement/moved",[n]),n}export function removeFormElement(e,t){let o;return getUtility().isUndefinedOrNull(e)&&(e=getCurrentlySelectedFormElement()),getFormElementDefinition(e,"_isTopLevelFormElement")&&getFormElementDefinition(e,"_isCompositeFormElement")&&1===getRootFormElement().get("renderables").length?Notification.error(getFormElementDefinition(getRootFormElement(),"modalRemoveElementLastAvailablePageFlashMessageTitle"),getFormElementDefinition(getRootFormElement(),"modalRemoveElementLastAvailablePageFlashMessageMessage"),2):(o=getFormEditorApp().removeFormElement(e,!1),t||getPublisherSubscriber().publish("view/formElement/removed",[o])),o}export function createAndAddPropertyCollectionElement(e,t,o,r,n,i){getFormEditorApp().createAndAddPropertyCollectionElement(e,t,o,r,n),i||getPublisherSubscriber().publish("view/collectionElement/new/added",[e,t,o,r,n])}export function movePropertyCollectionElement(e,t,o,r,n,i){getUtility().isUndefinedOrNull(n)&&(n=getCurrentlySelectedFormElement()),getFormEditorApp().movePropertyCollectionElement(e,t,o,r,n,!1),i||getPublisherSubscriber().publish("view/collectionElement/moved",[e,t,o,r,n])}export function removePropertyCollectionElement(e,t,o,r){let n,i;getFormEditorApp().removePropertyCollectionElement(e,t,o);const l=getFormEditorApp().getPropertyCollectionElementConfiguration(e,t);if("array"===$.type(l.editors))for(let e=0,t=l.editors.length;e<t;++e)if("array"===$.type(l.editors[e].additionalElementPropertyPaths))for(let t=0,o=l.editors[e].additionalElementPropertyPaths.length;t<o;++t)getCurrentlySelectedFormElement().unset(l.editors[e].additionalElementPropertyPaths[t],!0);else if("validationErrorMessage"===l.editors[e].identifier&&(i=getFormEditorApp().buildPropertyPath(l.editors[e].propertyPath),n=getCurrentlySelectedFormElement().get(i),!getUtility().isUndefinedOrNull(n))){for(let t=0,o=l.editors[e].errorCodes.length;t<o;++t)for(let o=0,r=n.length;o<r;++o)parseInt(l.editors[e].errorCodes[t],10)===parseInt(n[o].code,10)&&(n.splice(o,1),--r);getCurrentlySelectedFormElement().set(i,n)}r||getPublisherSubscriber().publish("view/collectionElement/removed",[e,t,o])}export function refreshSelectedElementItemsBatch(e){getUtility().isUndefinedOrNull(e)&&(e=!0);const t=getFormElementDefinition(getCurrentlySelectedFormElement(),void 0);if(getStage().removeAllStageToolbars(),removeAllStageElementSelectionsBatch(),removeAllStructureSelections(),!getFormEditorApp().isRootFormElementSelected()){removeStructureRootElementSelection(),addStructureSelection();const o=getStage().getAbstractViewFormElementDomElement();t._isTopLevelFormElement?addStagePanelSelection():(o.addClass(getHelper().getDomElementClassName("selectedFormElement")),getStage().createAndAddAbstractViewFormElementToolbar(o,void 0,e)),getStage().getAllFormElementDomElements().parent().removeClass(getHelper().getDomElementClassName("selectedCompositFormElement")),!t._isTopLevelFormElement&&t._isCompositeFormElement&&o.parent().addClass(getHelper().getDomElementClassName("selectedCompositFormElement"))}}export function selectPageBatch(e){assert("number"===$.type(e),'Invalid parameter "pageIndex"',1478651732),assert(e>=0,'Invalid parameter "pageIndex"',1478651733),assert(e<getRootFormElement().get("renderables").length,'Invalid parameter "pageIndex"',1478651734),getFormEditorApp().setCurrentlySelectedFormElement(getRootFormElement().get("renderables")[e]),renewStructure(),renderPagination(),refreshSelectedElementItemsBatch(),renderInspectorEditors()}export function removeAllStageElementSelectionsBatch(){getStage().getAllFormElementDomElements().removeClass(getHelper().getDomElementClassName("selectedFormElement")),removeStagePanelSelection(),getStage().getAllFormElementDomElements().parent().removeClass(getHelper().getDomElementClassName("sortableHover"))}export function onViewReadyBatch(){$(getHelper().getDomElementDataIdentifierSelector("structureSection")).css({width:configuration.panels.structure.width+"px",insetStart:"-="+configuration.panels.structure.width+"px"}),$(getHelper().getDomElementDataIdentifierSelector("inspectorSection")).css({width:configuration.panels.inspector.width+"px",insetEnd:"-="+configuration.panels.inspector.width+"px"}),$(getHelper().getDomElementClassName("headerButtonBar",!0)).css({"margin-inline-start":configuration.panels.structure.width+"px"}),$(getHelper().getDomElementDataIdentifierSelector("stageContainer")).css({"margin-inline-start":configuration.panels.stage.marginLeft+"px","margin-inline-end":configuration.panels.stage.marginRight+"px"}),hideComponent($(getHelper().getDomElementDataIdentifierSelector("buttonStageNewElementBottom"))),hideComponent($(getHelper().getDomElementDataIdentifierSelector("stageNewElementRow"))),setStageHeadline(),setStructureRootElementTitle(),renderAbstractStageArea(!1),renewStructure(),addStructureRootElementSelection(),renderInspectorEditors(),renderPagination(),hideComponent($(getHelper().getDomElementDataIdentifierSelector("moduleLoadingIndicator"))),showComponent($(getHelper().getDomElementDataIdentifierSelector("moduleWrapper"))),showComponent($(getHelper().getDomElementDataIdentifierSelector("buttonHeaderSave"))),showComponent($(getHelper().getDomElementDataIdentifierSelector("buttonHeaderSettings"))),showComponent($(getHelper().getDomElementDataIdentifierSelector("buttonHeaderClose"))),showComponent($(getHelper().getDomElementDataIdentifierSelector("buttonHeaderNewPage"))),showComponent($(getHelper().getDomElementDataIdentifierSelector("buttonHeaderUndo"))),showComponent($(getHelper().getDomElementDataIdentifierSelector("buttonHeaderRedo"))),setButtonActive($(getHelper().getDomElementDataIdentifierSelector("buttonHeaderViewModeAbstract")))}export function onAbstractViewDndStartBatch(e,t){$(t).removeClass(getHelper().getDomElementClassName("sortableHover"))}export function onAbstractViewDndChangeBatch(e,t,o){getStage().getAllFormElementDomElements().parent().removeClass(getHelper().getDomElementClassName("sortableHover")),o&&getStage().getAbstractViewParentFormElementWithinDomElement(e).parent().addClass(getHelper().getDomElementClassName("sortableHover"))}export function onAbstractViewDndUpdateBatch(e,t,o,r){let n,i;r?n=moveFormElement(t,"before",r):o?n=moveFormElement(t,"after",o):(i=getStage().getAbstractViewParentFormElementIdentifierPathWithinDomElement(e),i?n=moveFormElement(t,"inside",i):assert(!1,"Next element, previous or parent element need to be set.",1472502237)),getStage().getAbstractViewFormElementWithinDomElement(e).attr(getHelper().getDomElementDataAttribute("elementIdentifier"),n.get("__identifierPath"))}export function onStructureDndChangeBatch(e,t,o){getStructure().getAllTreeNodes().parent().removeClass(getHelper().getDomElementClassName("sortableHover")),getStage().getAllFormElementDomElements().parent().removeClass(getHelper().getDomElementClassName("sortableHover")),o&&(getStructure().getParentTreeNodeWithinDomElement(e).parent().addClass(getHelper().getDomElementClassName("sortableHover")),getStage().getAbstractViewFormElementDomElement(o).parent().addClass(getHelper().getDomElementClassName("sortableHover")))}export function onStructureDndUpdateBatch(e,t,o,r){let n,i;r?n=moveFormElement(t,"before",r):o?n=moveFormElement(t,"after",o):(i=getStructure().getParentTreeNodeIdentifierPathWithinDomElement(e),i?n=moveFormElement(t,"inside",i):getFormEditorApp().assert(!1,"Next element, previous or parent element need to be set.",1479048646)),getStructure().getTreeNodeWithinDomElement(e).attr(getHelper().getDomElementDataAttribute("elementIdentifier"),n.get("__identifierPath"))}export function closeEditor(){document.location.href=$(getHelper().getDomElementDataIdentifierSelector("buttonHeaderClose")).prop("href")}export function setElementValidationErrorClass(e,t){getFormEditorApp().getUtility().isUndefinedOrNull(t)?e.addClass(getHelper().getDomElementClassName("validationErrors")):e.addClass(getHelper().getDomElementClassName(t))}export function removeElementValidationErrorClass(e,t){getFormEditorApp().getUtility().isUndefinedOrNull(t)?e.removeClass(getHelper().getDomElementClassName("validationErrors")):e.removeClass(getHelper().getDomElementClassName(t))}export function showComponent(e){e.removeClass(getHelper().getDomElementClassName("hidden")).show()}export function hideComponent(e){e.addClass(getHelper().getDomElementClassName("hidden")).hide()}export function enableButton(e){e.prop("disabled",!1).removeClass(getHelper().getDomElementClassName("disabled"))}export function disableButton(e){e.prop("disabled","disabled").addClass(getHelper().getDomElementClassName("disabled"))}export function setButtonActive(e){e.addClass(getHelper().getDomElementClassName("active"))}export function removeButtonActive(e){e.removeClass(getHelper().getDomElementClassName("active"))}export function showSaveButtonSpinnerIcon(){Icons.getIcon(getHelper().getDomElementDataAttributeValue("iconSaveSpinner"),Icons.sizes.small).then((function(e){$(getHelper().getDomElementDataIdentifierSelector("iconSave")).replaceWith($(e))}))}export function showSaveButtonSaveIcon(){Icons.getIcon(getHelper().getDomElementDataAttributeValue("iconSave"),Icons.sizes.small).then((function(e){$(getHelper().getDomElementDataIdentifierSelector("iconSaveSpinner")).replaceWith($(e))}))}export function showSaveSuccessMessage(){Notification.success(getFormElementDefinition(getRootFormElement(),"saveSuccessFlashMessageTitle"),getFormElementDefinition(getRootFormElement(),"saveSuccessFlashMessageMessage"),2)}export function showSaveErrorMessage(e){Notification.error(getFormElementDefinition(getRootFormElement(),"saveErrorFlashMessageTitle"),getFormElementDefinition(getRootFormElement(),"saveErrorFlashMessageMessage")+" "+e.message)}export function showErrorFlashMessage(e,t){Notification.error(e,t,2)}export function bootstrap(e,t){formEditorApp=e,Helper.bootstrap(formEditorApp),structureComponentSetup(),modalsComponentSetup(),inspectorsComponentSetup(),stageComponentSetup(),buttonsSetup(),addPropertyValidators(),loadAdditionalModules(t)}